// Copyright 1992-5 by Jon Dart.  All Rights Reserved.

#ifndef _BOOK_H
#define _BOOK_H

#include "bookread.h"
#include "bookdefs.h"
#include "log.h"

class Book
{
    // interface to the opening book.

    public:
		
    Book();
	
    ~Book();
		
    Move book_move( const Board &b, enum styles style = Balanced );
    // Returns a "book move" if there is one, NullMove otherwise.
    // NOTE: the promotion field of book_move may be wrong;
    // we don't set it.
		
    unsigned book_moves( const Board &b, Move *moves, 
    const unsigned limit);
    // Fills array "moves" with a list of all the book moves for
    // the given position.  Moves are sorted in decreasing order
    // of "goodness".  Moves that are not recommended at all are
    // are not included.  "limit" is the maximum number of moves
    // that can be stored in "moves".  The return value is the
    // number actually stored.		
		
    private:
		
    BOOL find_move( const Move &target, unsigned &node);
	
    Book_Reader *reader, *style_reader;
};

#endif

